/* based on: $XConsortium: xload.c,v 1.37 94/04/17 20:43:44 converse Exp $ */
/*

Copyright (c) 1989  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.

*/

/*
 * xpppload - display ISDN load average in a window
 *
 */

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <linux/isdn.h>

#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/StripChart.h>
#include <X11/Xmu/SysUtil.h>

#ifndef STREAMS
#if defined(linux) && defined(__powerpc__) \
    && (__GLIBC__ == 2 && __GLIBC_MINOR__ == 0)
/* kludge alert! */
#undef __GLIBC__
#endif
#include <sys/socket.h>		/* *BSD, Linux, NeXT, Ultrix etc. */
#ifndef linux
#include <net/if.h>
#include <net/ppp_defs.h>
#include <net/if_ppp.h>
#else
/* Linux */
#if __GLIBC__ >= 2
#include <asm/types.h>		/* glibc 2 conflicts with linux/types.h */
#include <net/if.h>
#else
#include <linux/types.h>
#include <linux/if.h>
#endif
#include <linux/ppp_defs.h>
#include <linux/if_ppp.h>
#endif /* linux */

#else	/* STREAMS */
#include <sys/stropts.h>	/* SVR4, Solaris 2, SunOS 4, OSF/1, etc. */
#include <net/ppp_defs.h>
#include <net/pppio.h>

#endif	/* STREAMS */

#include "xpppload.bit"

char *ProgramName;

static void quit();

/*
 * Definition of the Application resources structure.
 */

typedef struct _XPPPLoadResources {
  Boolean show_label;
  char *online_color;
  char *active_color;
  char *trying_color;
  char *activate;
  char *deactivate;
} XPPPLoadResources;

/*
 * Command line options table.  Only resources are entered here...there is a
 * pass over the remaining options after XtParseCommand is let loose.
 */

static XrmOptionDescRec options[] = {
 {"-scale",		"*load.minScale",	XrmoptionSepArg,	NULL},
 {"-update",		"*load.update",		XrmoptionSepArg,	NULL},
 {"-hl",		"*load.highlight",	XrmoptionSepArg,	NULL},
 {"-highlight",		"*load.highlight",	XrmoptionSepArg,	NULL},
 {"-label",		"*label.label",		XrmoptionSepArg,	NULL},
 {"-nolabel",		"*showLabel",	        XrmoptionNoArg,       "False"},
 {"-jumpscroll",	"*load.jumpScroll",	XrmoptionSepArg,	NULL},
 {"-online",		"*onlineColor",         XrmoptionSepArg,	NULL},
 {"-trying",		"*tryingColor",         XrmoptionSepArg,	NULL},
 {"-active",		"*activeColor",         XrmoptionSepArg,	NULL},
 {"-activate",		"*activate",		XrmoptionSepArg,	NULL},
 {"-deactivate",	"*deactivate",		XrmoptionSepArg,	NULL},
};

/*
 * The structure containing the resource information for the
 * Xpppload application resources.
 */

#define Offset(field) (XtOffsetOf(XPPPLoadResources, field))

static XtResource my_resources[] = {
  {"showLabel", XtCBoolean, XtRBoolean, sizeof(Boolean),
     Offset(show_label), XtRImmediate, (XtPointer) TRUE},
  {"onlineColor", "OnlineColor", XtRString, sizeof(char *),
     Offset(online_color), XtRString, NULL},
  {"activeColor", "ActiveColor", XtRString, sizeof(char *),
     Offset(active_color), XtRString, NULL},
  {"tryingColor", "TryingColor", XtRString, sizeof(char *),
     Offset(trying_color), XtRString, NULL},
  {"activate", "Activate", XtRString, sizeof(char *),
     Offset(activate), XtRString, NULL},
  {"deactivate", "Deactivate", XtRString, sizeof(char *),
     Offset(deactivate), XtRString, NULL},
};

#undef Offset

static XPPPLoadResources resources;

static XtActionsRec xpppload_actions[] = {
    { "quit",	quit },
};
static Atom wm_delete_window;

static char *IfName=NULL;

typedef struct {
  unsigned long ibytes;
  unsigned long obytes;
} Siobytes;

static Siobytes iobytes;
static Pixel onlinecolor, activecolor, tryingcolor, bgcolor;
static long last;
static int usageflags;
static int flags;
static Widget label_wid;
static char label_format[80];
static int online_now, online_last;
static int trying_now, trying_last;
static struct timeval tv_start, tv_last;
static long bytes_total;
static int secs_running;
static char num[100], history[160];

static int fd_info;
static struct ppp_stats cur, old;

/*
 * Exit with message describing command line format.
 */

void usage()
{
    fprintf (stderr, "usage:  %s [-options ...] ifname\n\n", ProgramName);
    fprintf (stderr, "where options include:\n");
    fprintf (stderr,
      "    -display dpy            X server on which to display\n");
    fprintf (stderr,
      "    -geometry geom          size and location of window\n");
    fprintf (stderr,
      "    -fn font                font to use in label\n");
    fprintf (stderr,
      "    -scale number           minimum number of scale lines\n");
    fprintf (stderr,
      "    -update seconds         interval between updates\n");
    fprintf (stderr,
      "    -label string           annotation text\n");
    fprintf (stderr,
      "    -bg color               background color\n");
    fprintf (stderr,
      "    -fg color               graph color\n");
    fprintf (stderr,
      "    -hl color               scale and text color\n");
    fprintf (stderr,
      "    -online color           background color when online\n");
    fprintf (stderr,
      "    -active color           background color when active for demand dialing\n");
    fprintf (stderr,
      "    -nolabel                removes the label from above the chart.\n");
    fprintf (stderr,
      "    -jumpscroll value       number of pixels to scroll on overflow\n");
    fprintf (stderr,
      "    -activate string        exec this to activate demand dialing\n");
    fprintf (stderr,
      "    -deactivate string      exec this to deactivate demand dialing\n");
    fprintf (stderr, "\n");
    exit(1);
}



int get_active()
{
  struct ifreq ifr;

  strcpy(ifr.ifr_name, IfName);
  if (ioctl(fd_info, SIOCGIFFLAGS, &ifr) < 0)
    return (-1);

  return(ifr.ifr_flags&IFF_UP);
}

#ifndef STREAMS
static void
get_ppp_stats(curp)
    struct ppp_stats *curp;
{
    struct ifpppstatsreq req;

    memset (&req, 0, sizeof (req));

#ifdef linux
    req.stats_ptr = (caddr_t) &req.stats;
#undef ifr_name
#define ifr_name ifr__name
#endif

    strncpy(req.ifr_name, IfName, sizeof(req.ifr_name));
    if (ioctl(fd_info, SIOCGPPPSTATS, &req) < 0) {
	fprintf(stderr, "%s: ", ProgramName);
	if (errno == ENOTTY)
	    fprintf(stderr, "kernel support missing\n");
	else
	    perror("couldn't get PPP statistics");
	exit(1);
    }
    *curp = req.stats;
}

#else	/* STREAMS */

int
strioctl(fd, cmd, ptr, ilen, olen)
    int fd, cmd, ilen, olen;
    char *ptr;
{
    struct strioctl str;

    str.ic_cmd = cmd;
    str.ic_timout = 0;
    str.ic_len = ilen;
    str.ic_dp = ptr;
    if (ioctl(fd, I_STR, &str) == -1)
	return -1;
    if (str.ic_len != olen)
	fprintf(stderr, "strioctl: expected %d bytes, got %d for cmd %x\n",
	       olen, str.ic_len, cmd);
    return 0;
}

static void
get_ppp_stats(curp)
    struct ppp_stats *curp;
{
    if (strioctl(fd_info, PPPIO_GETSTAT, curp, 0, sizeof(*curp)) < 0) {
	fprintf(stderr, "%s: ", ProgramName);
	if (errno == EINVAL)
	    fprintf(stderr, "kernel support missing\n");
	else
	    perror("couldn't get PPP statistics");
	exit(1);
    }
}

#endif /* STREAMS */


#define MAX0(a)		((int)(a) > 0? (a): 0)
#define V(offset)	MAX0(cur.offset - old.offset)
#define W(offset)	MAX0(ccs.offset - ocs.offset)

#define RATIO(c, i, u)	((c) == 0? 1.0: (u) / ((double)(c) + (i)))
#define CRATE(x)	RATIO(W(x.comp_bytes), W(x.inc_bytes), W(x.unc_bytes))

#define KBPS(n)		((n) / (interval * 1000.0))



void
InitLoadPoint()
{
  int i;

  iobytes.ibytes = 0;
  iobytes.obytes = 0;
  last = 0;
  usageflags = 0;
  online_last = 0;
  online_now = -1;
  trying_last = 0;
  trying_now = 0;
  gettimeofday(&tv_last, NULL);
  tv_last.tv_sec--; /* avoid devision by zero */
  tv_start = tv_last;
  bytes_total = 0;
  secs_running = 0;
  strcpy(num, "");
  get_ppp_stats(&cur);
  old=cur;
}


void
GetLoadPoint( w, closure, call_data )
Widget	w;
XtPointer closure;
XtPointer call_data;	/* pointer to (double) return value */
{
  double *loadavg = (double *)call_data;
  double cps = 0.0;
  int idx;
  int get_iobytes;
  char buf[4096];
  char s[120];
  char f[80];
  time_t t;
  struct timeval tv_now;
  struct tm *tm;
  char now[20];
  long bytes_delta;
  int secs_delta;
  Arg args[1];

  gettimeofday(&tv_now, NULL);
  secs_delta = (tv_now.tv_sec + tv_now.tv_usec / 1000000) -
    (tv_last.tv_sec + tv_last.tv_usec / 1000000);
  tv_last = tv_now;

  get_ppp_stats(&cur);
  bytes_delta  = V(p.ppp_ibytes)+V(p.ppp_obytes);
  online_now = get_active();

  cps = (double)bytes_delta / (double)secs_delta;
  if (cps < 0.0) cps = 0.0;

  if (online_now) {
    secs_running = (tv_now.tv_sec + tv_now.tv_usec / 1000000) -
      (tv_start.tv_sec + tv_start.tv_usec / 1000000);

    bytes_total += bytes_delta;
    if (!online_last) {
      bytes_total=0;
      t = time(NULL);
      tm = localtime(&t);
      sprintf(now, "%.2d:%.2d:%.2d", tm->tm_hour, tm->tm_min, tm->tm_sec);
      strcpy(history, now);
      strcat(history, "-");
      tv_start = tv_now;
      XtSetArg(args[0], XtNbackground, trying_now ? tryingcolor : onlinecolor);
      XtSetValues(w, args, 1);
    }
    if (resources.show_label) {
      t = time(NULL);
      tm = localtime(&t);
      sprintf(now, "%.2d:%.2d:%.2d", tm->tm_hour, tm->tm_min, tm->tm_sec);
      sprintf(f, "%s%%s", label_format);
      sprintf(s, f, "online",
	      secs_running / 60, secs_running % 60, cps,
	      bytes_total / 1024, history, now);
      XtSetArg (args[0], XtNlabel, s);
      XtSetValues (label_wid, args, ONE);
    }
  } else if ((online_now != online_last) || (trying_now != trying_last)) {
    if (online_last) {
      if (resources.show_label) {
	if (secs_running > 0) {
	  t = time(NULL);
	  tm = localtime(&t);
	  sprintf(now, "%.2d:%.2d:%.2d", tm->tm_hour, tm->tm_min, tm->tm_sec);
	  strcat(history, now);
	  strcat(history, " ");
	  sprintf(s, label_format, "offline",
		  secs_running / 60, secs_running % 60,
		  (double)bytes_total / (double)secs_running,
		  bytes_total / 1024, history);
	} else {
	  sprintf(s, "uninitialized %s", history);
	}
	XtSetArg (args[0], XtNlabel, s);
	XtSetValues (label_wid, args, ONE);
      }
    }
      
    if (!online_now) {
      XtSetArg(args[0], XtNbackground, trying_now ? tryingcolor : bgcolor);
      XtSetValues(w, args, 1);
    } else {
      XtSetArg(args[0], XtNbackground, trying_now ? tryingcolor : activecolor);
      XtSetValues(w, args, 1);
    }
  }

  online_last = online_now;
  trying_last = trying_now;
  old=cur;
  *loadavg = cps / 8000.0; /* unit: 1000Bytes/sec */
}



void ToggleActive(Widget w, XtPointer p, XEvent *e, Boolean *c)
{
  if (e->type == ButtonPress) {
    if (get_active()) {
      system(resources.deactivate);
    } else {
      system(resources.activate);
    }
  }
}



int main(argc, argv)
    int argc;
    char **argv;
{
    XtAppContext app_con;
    Widget toplevel, load, pane, load_parent;
    Arg args[1];
    Pixmap icon_pixmap = None;
    char *label;
    XrmValue namein, pixelout;
    time_t t;
    struct tm *tm;
    char now[20];
    int a;

    t = time(NULL);
    tm = localtime(&t);
    sprintf(now, "%.2d:%.2d:%.2d", tm->tm_hour, tm->tm_min, tm->tm_sec);
    sprintf(history, "(%s) ", now);

    ProgramName = argv[0];
    if (argc != 2) usage();
    IfName=XtNewString(argv[1]);

#ifndef STREAMS
    {
      struct ifreq ifr;
      
      fd_info = socket(AF_INET, SOCK_DGRAM, 0);
      if (fd_info < 0) {
	fprintf(stderr, "%s: ", ProgramName);
	perror("couldn't create IP socket");
	exit(1);
      }

#ifdef linux
#undef  ifr_name
#define ifr_name ifr_ifrn.ifrn_name
#endif
      strncpy(ifr.ifr_name, IfName, sizeof(ifr.ifr_name));
      if (ioctl(fd_info, SIOCGIFFLAGS, (caddr_t)&ifr) < 0) {
	fprintf(stderr, "%s: nonexistent interface '%s' specified\n",
		ProgramName, IfName);
	exit(1);
      }
    }

#else	/* STREAMS */
    {
#ifdef __osf__
      const char *dev = "/dev/streams/ppp";
#else
      const char *dev = "/dev/ppp";
#endif
      int unit=0;

      if (sscanf(IfName, "ppp%d", &unit) != 1) {
	fprintf(stderr, "%s: invalid interface '%s' specified\n",
		ProgramName, IfName);
      }

      if ((fd_info = open(dev, O_RDONLY)) < 0) {
	fprintf(stderr, "%s: couldn't open ", ProgramName);
	perror(dev);
	exit(1);
      }
      if (strioctl(fd_info, PPPIO_ATTACH, &unit, sizeof(int), 0) < 0) {
	fprintf(stderr, "%s: ppp%d is not available\n", ProgramName, unit);
	exit(1);
      }

#endif	/* STREAMS */

    /* For security reasons, we reset our uid/gid after doing the necessary
       system initialization and before calling any X routines. */
    InitLoadPoint();
    setgid(getgid());		/* reset gid first while still (maybe) root */
    setuid(getuid());

    toplevel = XtAppInitialize(&app_con, "XPPPLoad", options,
			       XtNumber(options),
			       &argc, argv, NULL, NULL, (Cardinal) 0);

    XtGetApplicationResources( toplevel, (XtPointer) &resources,
			      my_resources, XtNumber(my_resources),
			      NULL, (Cardinal) 0);

    
    /*
     * This is a hack so that f.delete will do something useful in this
     * single-window application.
     */
    XtAppAddActions (app_con, xpppload_actions, XtNumber(xpppload_actions));
    XtOverrideTranslations(toplevel,
		   XtParseTranslationTable ("<Message>WM_PROTOCOLS: quit()"));

    XtSetArg (args[0], XtNiconPixmap, &icon_pixmap);
    XtGetValues(toplevel, args, ONE);
    if (icon_pixmap == None) {
      XtSetArg(args[0], XtNiconPixmap,
	       XCreateBitmapFromData(XtDisplay(toplevel),
				     XtScreen(toplevel)->root,
				     (char *)xpppload_bits,
				     xpppload_width, xpppload_height));
      XtSetValues (toplevel, args, ONE);
    }

    if (resources.show_label) {
      pane = XtCreateManagedWidget ("paned", panedWidgetClass,
				    toplevel, NULL, ZERO);

      label_wid = XtCreateManagedWidget ("label", labelWidgetClass,
					 pane, NULL, ZERO);

      XtSetArg (args[0], XtNlabel, &label);
      XtGetValues(label_wid, args, ONE);

      strcpy(label_format, label);

      sprintf(now, "uninitialized %s", history);
      XtSetArg (args[0], XtNlabel, now);
      XtSetValues (label_wid, args, ONE);

      load_parent = pane;
    }
    else
      load_parent = toplevel;

    load = XtCreateManagedWidget ("load", stripChartWidgetClass,
				  load_parent, NULL, ZERO);

    XtSetArg (args[0], XtNbackground, &bgcolor);
    XtGetValues(toplevel, args, ONE);

    if (resources.online_color) {
      namein.addr = resources.online_color;
      namein.size = strlen(resources.online_color) + 1;
      XtConvert(load, XtRString, &namein, XtRPixel, &pixelout);
      if (!pixelout.addr) {
	fprintf(stderr, "could not convert online color `%s'.\n",
		resources.online_color);
        exit(1);
      }
      onlinecolor = *(Pixel*)(pixelout.addr);
    } else {
      onlinecolor = bgcolor;
    }

    if (resources.trying_color) {
      namein.addr = resources.trying_color;
      namein.size = strlen(resources.trying_color) + 1;
      XtConvert(load, XtRString, &namein, XtRPixel, &pixelout);
      if (!pixelout.addr) {
	fprintf(stderr, "could not convert trying color `%s'.\n",
		resources.online_color);
        exit(1);
      }
      tryingcolor = *(Pixel*)(pixelout.addr);
    } else {
      tryingcolor = bgcolor;
    }

    if (resources.active_color) {
      namein.addr = resources.active_color;
      namein.size = strlen(resources.active_color) + 1;
      XtConvert(load, XtRString, &namein, XtRPixel, &pixelout);
      if (!pixelout.addr) {
	fprintf(stderr, "could not convert active color `%s'.\n",
		resources.online_color);
        exit(1);
      }
      activecolor = *(Pixel*)(pixelout.addr);
    } else {
      activecolor = bgcolor;
    }

    XtAddCallback(load, XtNgetValue, GetLoadPoint, NULL);

    XtAddEventHandler(toplevel, ButtonPressMask, ButtonPressMask,
		      ToggleActive, NULL);
    
    XtRealizeWidget (toplevel);

    wm_delete_window = XInternAtom (XtDisplay(toplevel), "WM_DELETE_WINDOW",
				    False);
    (void) XSetWMProtocols (XtDisplay(toplevel), XtWindow(toplevel),
			    &wm_delete_window, 1);

    XtAppMainLoop(app_con);

    return 0;
}

static void quit (w, event, params, num_params)
    Widget w;
    XEvent *event;
    String *params;
    Cardinal *num_params;
{
    if (event->type == ClientMessage &&
        event->xclient.data.l[0] != wm_delete_window) {
        XBell (XtDisplay(w), 0);
        return;
    }
    XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
    exit (0);
}
